//-----------------------------------------------------------------------------
//Copyright  2000-2003 TogetherSoft Corporation, a wholly owned subsidiary of Borland Software Corporation. All rights reserved. All patents pending.
//-----------------------------------------------------------------------------
namespace CSCashSales.data_objects
{
    using System;

    /// <summary>
    /// Represent a container of data items.
    /// </summary>
    public interface IDataContainer
    {
		/// <summary>
		/// Returns a number of data items.
		/// </summary>
		int getCount();

		/// <summary>
		/// Gets a data item at the specified index.
		/// </summary>
		/// <param name="index"> The item index </param>
		IDataItem getDataItemAt( int index );

		/// <summary>
		/// Adds new data item.
		/// </summary>
		/// <param name="newItem"> The data item </param>
		void addDataItem( IDataItem newItem );

		/// <summary>
		/// Generates new free ID.
		/// </summary>
        int generateID();
    }
}
